#!/bin/bash

installed=0;
for username in $(dscl . list /Users UniqueID | awk '$2 > 500 { print $1 }'); do
	if [ -e /Users/"${username}"/Library/Application\ Support/SMART\ Utility/DrivesList.plist ]; then
		installed=1;
		checkTime=`defaults read /Users/"${username}"/Library/Application\ Support/SMART\ Utility/DrivesList.plist CheckTime`
		problemDriveCount=`defaults read /Users/"${username}"/Library/Application\ Support/SMART\ Utility/DrivesList.plist SUProblemDrivesCount`
		if [ "$problemDriveCount" -gt 0 ]; then
			for i in {0..."$problemDriveCount"}; do
				driveHealth=`/usr/libexec/PlistBuddy /Users/"${username}"/Library/Application\ Support/SMART\ Utility/DrivesList.plist -c "print SUProblemDrives:0:DriveHealth"`
				driveNames=`/usr/libexec/PlistBuddy /Users/"${username}"/Library/Application\ Support/SMART\ Utility/DrivesList.plist -c "print SUProblemDrives:0:DriveNames"`
				driveSN=`/usr/libexec/PlistBuddy /Users/"${username}"/Library/Application\ Support/SMART\ Utility/DrivesList.plist -c "print SUProblemDrives:0:DriveSN"`
				driveModel=`/usr/libexec/PlistBuddy /Users/"${username}"/Library/Application\ Support/SMART\ Utility/DrivesList.plist -c "print SUProblemDrives:0:DriveModel"`
				driveSize=`/usr/libexec/PlistBuddy /Users/"${username}"/Library/Application\ Support/SMART\ Utility/DrivesList.plist -c "print SUProblemDrives:0:DriveSN"`
				# ***NOTE***
				# Customize this echo to your desired output format. Maybe you only want the health and names, or maybe you want everything. Do that here. 
				# This one is an example
				echo "<result>At ${checkTime}${driveHealth}: Drive '${driveNames}' with SN '${driveSN}'</result>"
			done
    		else
			echo "<result>At ${checkTime}, All drives passed</result>"
		fi
	fi
done

if [ "$installed" = 0 ]; then
	echo "<result>Not Installed</result>"	
fi

exit 0